//
//  CollectionsAppDelegate.m
//  Collections
//
//  Created by Jonathan Diehl on 02.03.11.
//  Copyright 2011 RWTH. All rights reserved.
//

#import "CollectionsAppDelegate.h"
#import "Logger.h"

@implementation CollectionsAppDelegate

@synthesize window;


// application started
- (BOOL)application:(UIApplication *)application didFinishLaunchingWithOptions:(NSDictionary *)launchOptions
{
	NSBundle *mainBundle = [NSBundle mainBundle];
	Logger *logger = [[Logger alloc] init];
	
	NSDictionary *dictionary = [NSDictionary dictionaryWithContentsOfFile:[mainBundle pathForResource:@"dictionary" ofType:@"plist"]];
	[logger logDictionary:dictionary];
	
	NSArray *array = [NSArray arrayWithContentsOfFile:[mainBundle pathForResource:@"array" ofType:@"plist"]];
	[logger logArray:array];
	
    [self.window makeKeyAndVisible];
    
    return YES;
}


@end
